package text

import (
	"fmt"
)

// Human method returns results in human readable format.
func Human(size int64) string {
	floatsize := float32(size)

	units := [...]string{"", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei", "Zi", "Yi"}
	for _, unit := range units {
		if floatsize < 1024 {
			return fmt.Sprintf("%.1f %sB", floatsize, unit)
		}

		floatsize /= 1024
	}

	return fmt.Sprintf("%d%s", size, "B")
}
